/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.util.Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class AccessControlList {
    private static Logger logger = Logger.getMyLogger((class$jade$util$AccessControlList == null ? (class$jade$util$AccessControlList = AccessControlList.class$("jade.util.AccessControlList")) : class$jade$util$AccessControlList).getName());
    private String blackFileName = null;
    private String whiteFileName = null;
    private InternalACL black_iacl;
    private InternalACL white_iacl;
    static /* synthetic */ Class class$jade$util$AccessControlList;

    public void setBlack(String blackFileName) {
        this.blackFileName = blackFileName;
        this.refresh_black();
    }

    public void setWhite(String whiteFileName) {
        this.whiteFileName = whiteFileName;
        this.refresh_white();
    }

    public boolean isAllowed(String section, String value) {
        boolean retVal = false;
        if (logger.isLoggable(Logger.FINER)) {
            logger.log(Logger.FINER, "Current dir: " + System.getProperty("user.dir") + "\n" + "\nChecking files:\n    black=" + this.blackFileName + "\n    white=" + this.whiteFileName + "\n");
        }
        boolean isInBlack = false;
        boolean isInWhite = false;
        if (this.black_iacl != null) {
            isInBlack = this.isInList(this.black_iacl, section, value);
        }
        if (this.white_iacl != null) {
            isInWhite = this.isInList(this.white_iacl, section, value);
        }
        if (logger.isLoggable(Logger.FINE)) {
            logger.log(Logger.FINE, " isInBlack=" + isInBlack + " isInWhite=" + isInWhite);
        }
        retVal = !isInBlack && isInWhite;
        return retVal;
    }

    private boolean isInList(InternalACL iacl, String section, String value) {
        boolean retVal = false;
        try {
            String currSection = "";
            int pos = 0;
            while (pos < iacl.size) {
                if (iacl.sectionName[++pos] != null) {
                    currSection = iacl.sectionName[pos];
                    logger.log(Logger.FINER, "Encountered section named: '" + currSection + "'");
                    continue;
                }
                if (!currSection.equals(section) || iacl.pat[pos] == null) continue;
                Matcher m = null;
                m = iacl.pat[pos].matcher(value);
                if (logger.isLoggable(Logger.FINER)) {
                    logger.log(Logger.FINER, "(" + iacl.fileName + ")  " + "  pattern=" + iacl.pat[pos].pattern() + "  matcher=" + value + "\n");
                }
                boolean b = m.matches();
                if (logger.isLoggable(Logger.FINER)) {
                    logger.log(Logger.FINER, "     " + value + "->" + b + "\n");
                }
                if (!b) continue;
                retVal = true;
            }
        }
        catch (Throwable e) {
            logger.log(Logger.WARNING, "Exception while checking " + iacl.fileName, e);
            retVal = false;
        }
        return retVal;
    }

    public void refresh() {
        this.refresh_black();
        this.refresh_white();
    }

    private void refresh_black() {
        try {
            this.black_iacl = this.file2iacl(this.blackFileName);
        }
        catch (IOException e) {
            logger.log(Logger.WARNING, "Exception while checking: " + this.blackFileName, e);
        }
    }

    private void refresh_white() {
        try {
            this.white_iacl = this.file2iacl(this.whiteFileName);
        }
        catch (IOException e) {
            logger.log(Logger.WARNING, "Exception while checking: " + this.whiteFileName, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private InternalACL file2iacl(String fileName) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        int n = 0;
        while (in.readLine() != null) {
            ++n;
        }
        in.close();
        InternalACL iacl = new InternalACL(n + 1);
        iacl.fileName = fileName;
        logger.log(Logger.FINER, "Opening acc.control list file:" + fileName + " (" + n + " lines)");
        in = new BufferedReader(new FileReader(fileName));
        int pos = 0;
        while ((str = in.readLine()) != null) {
            void var5_6;
            ++pos;
            str = var5_6.trim();
            if (str.startsWith("#")) continue;
            if (str.endsWith(":")) {
                iacl.sectionName[pos] = str.substring(0, str.length() - 1);
                continue;
            }
            try {
                iacl.pat[pos] = Pattern.compile(str);
            }
            catch (PatternSyntaxException pse) {
                logger.log(Logger.WARNING, "Error in expression acc.control list file:" + fileName + " (line:" + pos + ")");
            }
        }
        in.close();
        return iacl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InternalACL {
        public Pattern[] pat;
        public String[] sectionName;
        public int size;
        public String fileName;

        public InternalACL(int dim) {
            this.size = dim;
            this.pat = new Pattern[dim + 1];
            this.sectionName = new String[dim + 1];
        }
    }
}

